// Header File
// Created 25/12/2003; 22:26:51
//Gestion des bonus...

//Variables gestion bonus
static short BONUS_xpos [20];																	//Position suivant x
static short BONUS_ypos [20];																	//Position suivant y
static unsigned char BONUS_SPRITE_ANIM [20];									//Sprite d'animation
static unsigned char BONUS_TYPE[20];													//Numro du bonus
static unsigned char BONUS_SHOWANIM [20];											//Affichage animation
static unsigned char nbrBonus=0;															//Nombre de bonus

#define INT1_BONUS												24
#define __INT1_BONUS_FREQUENCY						3084
static unsigned short __COUNTER_BONUS=0;
static BOOL INT_START_BONUS;

//Dimensions Bonus
#define BONUS_HEIGHT		7
#define BONUS_WIDTH			14
#define BONUS_HEIGHT2		6
#define BONUS_WIDTH2		13

//Table de Bonus
#define BONUS_L					0				//Tir
#define BONUS_E					1				//Grande raquette
#define BONUS_M_BLANC		2				//3 Billes (regnr)
#define BONUS_S					3				//Vitesse d'origine
#define BONUS_C					4				//Colle
#define BONUS_P					5				//Vie
#define BONUS_B					6				//Passage niveau
#define BONUS_D					7				//5 Billes
#define BONUS_I					8				//Traine fantme
#define BONUS_R					9				//Rtrcissement
#define BONUS_M_ROSE		10			//Bille de feu
#define BONUS_T					11			//Double raquette
#define BONUS_OR				12			//Alatoire

//Prototypes
void DeleteBonus (unsigned char item);
void ApplicateBonus (unsigned char item, unsigned char type);
void DeleteAllBonus (void);

//Ajoute un bonus
void NewBonus (short x, short y,unsigned char type)
{
	if (nbrBonus==20) return;
	
	INT_START_BONUS=FALSE;
	
	//Coordonnes Bonus
	BONUS_xpos [nbrBonus]=x;
	BONUS_ypos [nbrBonus]=y;
	
	BONUS_SHOWANIM [nbrBonus]=0;
	
	//Sprites
	BONUS_TYPE [nbrBonus]=type;
	BONUS_SPRITE_ANIM [nbrBonus++]=0;
	
	INT_START_BONUS=TRUE;
}

//Efface un bonus
void DeleteBonus (unsigned char item)
{	
	//Interruption
	INT_START_BONUS=FALSE;
	
	//Coordonnes
	memmove ((void *)(BONUS_xpos+item),(void *)(BONUS_xpos+item+1),(nbrBonus-item-1)<<1);
	memmove ((void *)(BONUS_ypos+item),(void *)(BONUS_ypos+item+1),(nbrBonus-item-1)<<1);
	
	//Compteur animation
	memmove ((void *)(BONUS_SHOWANIM+item),(void *)(BONUS_SHOWANIM+item+1),nbrBonus-item-1);
	
	//Sprites
	memmove ((void *)(BONUS_TYPE+item),(void *)(BONUS_TYPE+item+1),nbrBonus-item-1);
	memmove ((void *)(BONUS_SPRITE_ANIM+item),(void *)(BONUS_SPRITE_ANIM+item+1),nbrBonus-item-1);
	
	nbrBonus--;
	
	INT_START_BONUS=TRUE;
}

//Dessine les bonus
void DrawAllBonus (void)
{
	unsigned char mask=0;
	
	//Parcours Bonus
	for (int i=0;i<nbrBonus;i++)
	{
		//Gestion masks
		mask=0;
		if (BONUS_TYPE [i]==9) mask=1;
		
		//Dessine ombre
		if (((BONUS_ypos [i]+(BONUS_HEIGHT+(BONUS_HEIGHT/2)))<GAME_HEIGHT2) && ((BONUS_xpos [i]+(BONUS_WIDTH+(BONUS_WIDTH/4)))<GAME_WIDTH2))
			DrawBonusShadow (BONUS_xpos [i]+(BONUS_WIDTH/4),BONUS_ypos [i]+(BONUS_HEIGHT/2),BONUS_HEIGHT,SPRITE_BONUS_mask [1],ScreenBuffer);
		
		//Dessine Bonus	
		if ((BONUS_ypos [i]+BONUS_HEIGHT2)<=GAME_WIDTH2)
			DrawBonus (BONUS_xpos [i],BONUS_ypos [i],BONUS_HEIGHT,SPRITE_BONUS [BONUS_TYPE [i]][BONUS_SPRITE_ANIM [i]],SPRITE_BONUS_mask [mask],ScreenBuffer);
	}
}

//Collision avec l'cran
void Bonus_CollideWithScreen (void)
{
	//Parcours Bonus
	for (int i=0;i<nbrBonus;i++)
	{
		//Si dpassement cran
		if (BONUS_ypos [i]==(GAME_HEIGHT2-BONUS_HEIGHT2))
		{
			//Efface bonus
			DeleteBonus (i--);
		}
	}
}

//Gestion de Bonus
void SetBonus (short x, short y)
{
	unsigned char rint=GCL_Random (80);
	
	//4
	if (rint<4) rint=BONUS_L;
	//4
	else if ((rint>=4) && (rint<8)) rint=BONUS_E;
	//3
	else if ((rint>=8) && (rint<11)) rint=BONUS_M_BLANC;
	//3
	else if ((rint>=11) && (rint<14)) rint=BONUS_S;
	//4
	else if ((rint>=14) && (rint<18)) rint=BONUS_C;
	//1
	else if (rint==18) rint=BONUS_P;
	//1
	else if (rint==19) rint=BONUS_B;
	//2
	else if ((rint==20) || (rint==21)) rint=BONUS_D;
	//2
	else if ((rint==22) || (rint==23)) rint=BONUS_I;
	//4
	else if ((rint>=24) && (rint<28)) rint=BONUS_R;
	//3
	else if ((rint>=28) && (rint<31)) rint=BONUS_M_ROSE;
	//2
	else if ((rint==31) || (rint==32)) rint=BONUS_T;
	else if (rint==33) rint=BONUS_OR;
	else rint=0xFF;
	
	/*rint=GCL_Random (3);
	if (rint==0) rint=BONUS_C;
	else rint=BONUS_M_BLANC;*/
	
	//rint=BONUS_T;
			
	if (rint!=0xFF)	NewBonus (x,y,rint);
}

//Collision avec une raquette
void Bonus_CollideWithRacket (void)
{
	unsigned char type;
	
	//Parcours rackets
	for (int i=0;i<nbrRacket;i++)
	{
		for (int j=0;j<nbrBonus;j++)
		{
			//Si collision
			if (Test_Collide_0 (Racket [i]->xpos, Racket [i]->ypos, BONUS_xpos [j], BONUS_ypos [j], Racket [i]->size_x, Racket [i]->size_y, BONUS_WIDTH, BONUS_HEIGHT))
			{
				//Sauvegarde du numro du Bonus
				type=BONUS_TYPE [j];
				
				//Efface Bonus
				DeleteBonus (j--);
				
				//Applique le Bonus
				ApplicateBonus (i,type);
				return;
			}
		}
	}
}

//Application du Bonus
void ApplicateBonus (unsigned char item, unsigned char type)
{
	//Si double raquette, appartenance
	if (Racket [item]->isDoubleRacket) item=Racket [item]->parent;
	
	//Si en train de mourir ou natre
	if ((Racket [item]->size==7) || (Racket [item]->size==8)) return;
	
	//Attente fin bonus
	//if (Racket [item]->Bonus) return;
	
	//Bonus en cours
	//Racket [item]->Bonus=TRUE;
	
	switch (type)
	{
		//Laser
		case BONUS_L:
			//Enleve 3 Billes
			Bonus_No3Billes (item);
			//Pas de Bonus Ghost
			Bonus_DeleteGhost (item);
			//Pas de billes de feu
			Bonus_BilleNoFire (item);
			//Annule Bonus colle
			Bonus_DesactivateColle (item);
			//Efface Double Racket
			Bonus_DeleteRacket (item);
			//Change racket en vaisseau de tirs
			ChangeRacket (item,RACKET_SHOOT);
		break;
		
		//Expand
		case BONUS_E:
			//Enleve 3 Billes
			Bonus_No3Billes (item);
			//Pas de Bonus Ghost
			Bonus_DeleteGhost (item);
			//Pas de billes de feu
			Bonus_BilleNoFire (item);
			//Annule Bonus colle
			Bonus_DesactivateColle (item);
			//Efface double racket
			Bonus_DeleteRacket (item);
			//Change la taille de la raquette
			ChangeRacket (item,RACKET_EXPAND);
		break;
		
		//3 Billes regnnre
		case BONUS_M_BLANC:
			//Dcolle billes
			Bonus_RacketNoStickedAllBilles (item);
			//Pas de billes de feu
			Bonus_BilleNoFire (item);
			//Ajoute les Billes
			Bonus_Add3Billes (item);
		break;
		
		//Slow
		case BONUS_S:
			//Active Bonus vitesse
			Bonus_Slow (item);
		break;
		
		//Colle
		case BONUS_C:
			//Enleve 3 Billes
			Bonus_No3Billes (item);
			//Pas de Bonus Ghost
			Bonus_DeleteGhost (item);
			//Pas de billes de feu
			Bonus_BilleNoFire (item);
			//Dcolle billes
			Bonus_RacketNoStickedAllBilles (item);
			//Efface double racket
			Bonus_DeleteRacket (item);
			//Change en taille normale si Vaisseau de tir
			if (Racket [item]->size==RACKET_SHOOT)
				ChangeRacket (item,RACKET_NORMAL);
			//Active collage
			Bonus_ActivateColle (item);
		break;
		
		//Vie
		case BONUS_P:
			//Ajoute et dessine vies
			nbrLifes++;
			DrawLifes ();
		break;
		
		//Niveau suivant
		case BONUS_B:
			EndLevel=TRUE;
			
			//Efface toutes les Billes
			DeleteAllBilles (HUMAIN0);
		
			//Efface tous les missiles
			DeleteAllMissiles ();
	
			//Efface bonus
			DeleteAllBonus ();
			
			//Efface les monstres
			DeleteAllMonsters ();
	
			//Taille normal
			DESTROY_ANIM_DOUBLE_RACKET (HUMAIN0);
			ChangeRacket (HUMAIN0,RACKET_NORMAL);
	
			//Ne pas jouer animation
			PlayAnimEndLevel=FALSE;
		break;
		
		//5 Billes
		case BONUS_D:
			//Enleve 3 Billes
			Bonus_No3Billes (item);
			//Dcolle billes
			Bonus_RacketNoStickedAllBilles (item);
			//Ajoute 5 billes
			Bonus_Add5Billes (item);
		break;
		
		//Traine fantome
		case BONUS_I:
			//Enleve 3 Billes
			Bonus_No3Billes (item);
			//Pas de billes de feu
			Bonus_BilleNoFire (item);
			//Annule Bonus colle
			Bonus_DesactivateColle (item);
			//Efface double racket
			Bonus_DeleteRacket (item);
			//Change la taille de la raquette
			ChangeRacket (item,RACKET_NORMAL);
			//Fantme
			Bonus_CreateGhost (item);
		break;
		
		//Rtrcissement
		case BONUS_R:
			//Enleve 3 Billes
			Bonus_No3Billes (item);
			//Pas de Bonus Ghost
			Bonus_DeleteGhost (item);
			//Pas de billes de feu
			Bonus_BilleNoFire (item);
			//Annule Bonus colle
			Bonus_DesactivateColle (item);
			//Efface double racket
			Bonus_DeleteRacket (item);
			//Change taille de la racket
			ChangeRacket (item,RACKET_SMALL);
		break;
		
		//Bille de feu
		case BONUS_M_ROSE:
			//Enleve 3 Billes
			Bonus_No3Billes (item);
			//Pas de Bonus Ghost
			Bonus_DeleteGhost (item);
			//Annule Bonus colle
			Bonus_DesactivateColle (item);
			//Efface double racket
			Bonus_DeleteRacket (item);
			//Change en taille normale si Vaisseau de tir
			if (Racket [item]->size==RACKET_SHOOT)
				ChangeRacket (item,RACKET_NORMAL);
			//Billes de feu
			Bonus_BilleFire (item);
		break;
		
		//Double raquette
		case BONUS_T:
			//Enleve 3 Billes
			Bonus_No3Billes (item);
			//Pas de Bonus Ghost
			Bonus_DeleteGhost (item);
			//Pas de billes de feu
			Bonus_BilleNoFire (item);
			//Annule Bonus colle
			Bonus_DesactivateColle (item);
			//Raquette moyenne
			ChangeRacket (item,RACKET_NORMAL);
			//Active double racket
			Bonus_AddRacket (item);
		break;
		
		//Alatoire
		case BONUS_OR:
		
		break;
	}
	
	//Fin Bonus
	//Racket [item]->Bonus=FALSE;
}

//Efface tous les Bonus
void DeleteAllBonus (void)
{
	//Parcours Bonus
	for (int i=0;i<nbrBonus;i++)
		//Efface bonus
		DeleteBonus (i--);
}